varying vec4 f_colorLight;

varying float f_factor_alpha;

uniform vec3 water_color;

#ifdef MULTI_TEX
uniform sampler2D texture_foam;
varying vec2 f_texcoord_foam;
varying float f_factor_foam;
#endif

#ifdef FOG
varying float f_fogFactor;
varying float f_fogFactorGround;
#endif



void main(void)
{
	if(f_factor_alpha == 0.0)
		discard;

	vec4 colorResult = vec4(water_color, 1.0);

#ifdef MULTI_TEX
	vec4 colorTexFoam = texture2D(texture_foam, f_texcoord_foam);
	colorResult = mix(colorResult, vec4(colorTexFoam.rgb, 1.0), f_factor_foam*colorTexFoam.a);
#endif

	//Result
	colorResult = f_colorLight * colorResult;
	colorResult.w = getWaterAlpha(f_factor_alpha);

#ifdef WATER_SHADER_ALPHA
	colorResult.w *= WATER_SHADER_ALPHA_VALUE;
#endif

#ifdef FOG
	colorResult.rgb = mix(colorResult.rgb, FOG_COLOR*FOG_COLOR_ADAPT, f_fogFactor);
	colorResult.rgb = mix(colorResult.rgb, FOG_COLOR_GROUND, f_fogFactorGround);
#endif

	gl_FragColor = colorResult;
}
